/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.File;
import java.io.IOException;
import java.util.zip.CRC32;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.crypto.CryptoEngine;
import jpcsp.crypto.KeyVault;
import jpcsp.filesystems.SeekableRandomFile;
import jpcsp.settings.Settings;
import org.apache.log4j.Logger;

public class scePauth
extends HLEModule {
    public static Logger log = Modules.getLogger("scePauth");

    @HLEUnimplemented
    @HLEFunction(nid=-139835402, version=500)
    public int scePauth_F7AA47F6(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.inout) TPointer inputAddr, int inputLength, @BufferInfo(usage=BufferInfo.Usage.out) @CanBeNull TPointer32 resultLengthAddr, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.in) TPointer keyAddr) {
        CryptoEngine crypto = new CryptoEngine();
        byte[] in = inputAddr.getArray8(inputLength);
        byte[] key = keyAddr.getArray8(16);
        byte[] xor = new byte[16];
        for (int i = 0; i < 16; ++i) {
            xor[i] = (byte)(KeyVault.pauthXorKey[i] & 0xFF);
        }
        try {
            CRC32 crc = new CRC32();
            crc.update(in, 0, inputLength);
            int tag = (int)crc.getValue();
            String pauthDirName = String.format("%sPAUTH%c", Settings.getInstance().getDiscTmpDirectory(), Character.valueOf(File.separatorChar));
            String pauthFileName = pauthDirName + String.format("pauth-%s.bin", Integer.toHexString(tag));
            String pauthDecFileName = pauthDirName + String.format("pauth-%s.bin.decrypt", Integer.toHexString(tag));
            String pauthKeyFileName = pauthDirName + String.format("pauth-%s.key", Integer.toHexString(tag));
            File dec = new File(pauthDecFileName);
            if (dec.exists()) {
                log.info((Object)("Reading PAUTH data file from " + pauthDecFileName));
                SeekableRandomFile pauthPRXDec = new SeekableRandomFile(pauthDecFileName, "rw");
                int pauthSize = (int)pauthPRXDec.length();
                byte[] pauthDec = new byte[pauthSize];
                pauthPRXDec.read(pauthDec);
                pauthPRXDec.close();
                inputAddr.setArray(pauthDec, pauthSize);
                resultLengthAddr.setValue(pauthSize);
            } else {
                File f = new File(pauthDirName);
                f.mkdirs();
                log.info((Object)("Writting PAUTH data file to " + pauthFileName));
                log.info((Object)("Writting PAUTH key file to " + pauthKeyFileName));
                SeekableRandomFile pauthPRX = new SeekableRandomFile(pauthFileName, "rw");
                SeekableRandomFile pauthKey = new SeekableRandomFile(pauthKeyFileName, "rw");
                pauthPRX.write(in);
                pauthKey.write(key);
                pauthPRX.close();
                pauthKey.close();
                int reslength = crypto.getPRXEngine().DecryptPRX(in, inputLength, 5, xor, key);
                inputAddr.setArray(in, reslength);
                resultLengthAddr.setValue(reslength);
            }
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1732756643, version=500)
    public int scePauth_98B83B5D(TPointer inputAddr, int inputLength, @CanBeNull TPointer32 resultLengthAddr, TPointer keyAddr) {
        CryptoEngine crypto = new CryptoEngine();
        byte[] in = inputAddr.getArray8(inputLength);
        byte[] key = keyAddr.getArray8(16);
        byte[] xor = new byte[16];
        for (int i = 0; i < 16; ++i) {
            xor[i] = (byte)(KeyVault.pauthXorKey[i] & 0xFF);
        }
        try {
            CRC32 crc = new CRC32();
            crc.update(in, 0, inputLength);
            int tag = (int)crc.getValue();
            String pauthDirName = String.format("%sPAUTH%c", Settings.getInstance().getDiscTmpDirectory(), Character.valueOf(File.separatorChar));
            String pauthFileName = pauthDirName + String.format("pauth_%s.bin", Integer.toHexString(tag));
            String pauthDecFileName = pauthDirName + String.format("pauth_%s.bin.decrypt", Integer.toHexString(tag));
            String pauthKeyFileName = pauthDirName + String.format("pauth_%s.key", Integer.toHexString(tag));
            File dec = new File(pauthDecFileName);
            if (dec.exists()) {
                log.info((Object)("Reading PAUTH data file from " + pauthDecFileName));
                SeekableRandomFile pauthPRXDec = new SeekableRandomFile(pauthDecFileName, "rw");
                int pauthSize = (int)pauthPRXDec.length();
                byte[] pauthDec = new byte[pauthSize];
                pauthPRXDec.read(pauthDec);
                pauthPRXDec.close();
                inputAddr.setArray(pauthDec, pauthSize);
                resultLengthAddr.setValue(pauthSize);
            } else {
                File f = new File(pauthDirName);
                f.mkdirs();
                log.info((Object)("Writting PAUTH data file to " + pauthFileName));
                log.info((Object)("Writting PAUTH key file to " + pauthKeyFileName));
                SeekableRandomFile pauthPRX = new SeekableRandomFile(pauthFileName, "rw");
                SeekableRandomFile pauthKey = new SeekableRandomFile(pauthKeyFileName, "rw");
                pauthPRX.write(in);
                pauthKey.write(key);
                pauthPRX.close();
                pauthKey.close();
                int reslength = crypto.getPRXEngine().DecryptPRX(in, inputLength, 5, xor, key);
                inputAddr.setArray(in, reslength);
                resultLengthAddr.setValue(reslength);
            }
        }
        catch (IOException ioe) {
            log.error((Object)ioe);
        }
        return 0;
    }
}

